/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*-  */
/*
 * palindrome.c
 * Copyright (C) 2021 drdev <gualtieri@ieee.org>
 * 
 * palindrome is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * palindrome is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//to compile using gcc: gcc -o pp palindrome.c -lm

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

 /* Prototypes */
int strcmp (const char* str1, const char* str2);
char *strcpy(char *dest, const char *src);
char *strrev(char *str);
/* end of prototypes */

int p;
int limit = 10000000; //INT_MAX is 2147483647 on 64 bit systems
int hex=0; //set to 1 for hex output
char str1[32]="";
char str2[32]="";
FILE *outdata;

char *strrev(char *str)
{
//recreates the strrev function once present in string.h
      char *ptr1, *ptr2;

      if (! str || ! *str)
            return str;
      for (ptr1 = str, ptr2 = str + strlen(str) - 1; ptr2 > ptr1; ++ptr1, --ptr2)
      {
            *ptr1 ^= *ptr2;
            *ptr2 ^= *ptr1;
            *ptr1 ^= *ptr2;
      }
      return str;
}

int is_prime(int num)
{
//check whether a number is prime
int i;
if (num == 1)
{
return 0; 
}
//Otherwise, iterate from 2 to sqrt(num) and check
    for (i = 2; i <= sqrt(num); i++)
    {
        //if divisible, then not prime
        if (num % i == 0)
        {
            return 0;
        }
    }
 
    return 1;
}

int main(void)
{

  if ((outdata = fopen ("data.txt", "w")) == NULL)
    {
      printf ("\nOutput datafile cannot be opened.\n");
      exit (1);
    }

//strcmp()returns 0 if strings are equal

for(p=1;p<=limit;p++)
{
if(is_prime(p))
{
if(hex==1)
{
sprintf(str1,"%x",p);
strcpy(str2, str1);
if(strcmp(str1,strrev(str2))==0)
{
printf("%s\t", str1);
fprintf(outdata,"%s\n",str1);
}
}
else
{
sprintf(str1,"%d",p);
strcpy(str2, str1);
if(strcmp(str1,strrev(str2))==0)
{
printf("%s\t", str1);
fprintf(outdata,"%s\n",str1);
}
}
}
}

//fflush(outdata);

fclose (outdata);

  return (0);
}


